DROP TABLE IF EXISTS `site_core_backgrounds`;
CREATE TABLE `site_core_backgrounds` (
  `image_id` int(11) NOT NULL AUTO_INCREMENT,
  `image_name` varchar(255) NOT NULL,
  `image_cat` varchar(255) NOT NULL,
  `image_type` int(1) NOT NULL,
  `image_status` int(1) NOT NULL,
  `image_device` varchar(10) NOT NULL DEFAULT '1,2,3',
  `image_img` int(11) NOT NULL,
  `image_img_position_x` varchar(10) NOT NULL,
  `image_img_position_y` varchar(11) NOT NULL,
  `image_img_size` varchar(20) NOT NULL,
  `image_img_repeat` varchar(20) NOT NULL DEFAULT 'no-repeat',
  `image_img_fixed` int(1) NOT NULL,
  `image_color` varchar(11) NOT NULL,
  `image_color_alpha` float NOT NULL,
  `image_default` int(1) NOT NULL,
  `image_modules` text NOT NULL,
  `image_modules_global` text NOT NULL,
  `image_video` int(1) NOT NULL,
  `image_video_file` varchar(255) NOT NULL,
  `image_inverted` int(1) NOT NULL,
  `image_overlay` varchar(50) NOT NULL,
  `image_kb_scale` float NOT NULL,
  `image_kb_scale_to` float NOT NULL,
  `image_kb_duration` int(11) NOT NULL,
  `image_kb_fade` int(11) NOT NULL,
  `image_kb_transition` varchar(20) NOT NULL,
  `image_kb_posx` varchar(20) NOT NULL,
  `image_kb_posy` varchar(20) NOT NULL,
  `image_youtube` varchar(50) NOT NULL,
  `image_volume` int(3) NOT NULL,
  `image_start` int(10) NOT NULL,
  `image_particles` int(1) NOT NULL,
  `image_particles_file` int(1) NOT NULL,
  `image_particles_file_file` varchar(100) NOT NULL,
  `image_slider_transition` varchar(255) NOT NULL,
  `image_slider_duration` varchar(255) NOT NULL,
  `image_slider_transition_duration` int(11) NOT NULL,
  `image_color_start` varchar(7) NOT NULL,
  `image_color_start_alpha` float NOT NULL,
  `image_color_end` varchar(7) NOT NULL,
  `image_color_end_alpha` float NOT NULL,
  `image_color_dir` varchar(10) NOT NULL,
  `image_split_bg1` int(11) NOT NULL,
  `image_split_bg2` int(11) NOT NULL,
  `image_split_size` int(3) NOT NULL,
  `image_split_size_lg` int(3) NOT NULL,
  `image_split_size_md` int(3) NOT NULL,
  `image_split_size_sm` int(3) NOT NULL,
  `image_split_size_xs` int(3) NOT NULL,
  `image_par_size` int(3) NOT NULL,
  `image_par_speed` int(5) NOT NULL,
  `image_par_mode` varchar(15) NOT NULL,
  `image_par_scroll` varchar(10) NOT NULL,
  `image_par_dir` varchar(10) NOT NULL,
  `image_effect` int(2) NOT NULL,
  `image_scroll_dir` varchar(50) NOT NULL,
  `image_scroll_speed` int(11) NOT NULL,
  `image_scroll_speed_out` int(11) NOT NULL,
  PRIMARY KEY (`image_id`),
  KEY `image_status` (`image_status`),
  KEY `image_device` (`image_device`),
  KEY `image_default` (`image_default`),
  KEY `image_id` (`image_id`,`image_status`),
  KEY `image_id_2` (`image_id`,`image_status`,`image_device`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_backgrounds_assigns`;
CREATE TABLE `site_core_backgrounds_assigns` (
  `bg_id` int(11) NOT NULL AUTO_INCREMENT,
  `bg_background` int(11) NOT NULL,
  `bg_background_sec` int(11) NOT NULL,
  `bg_background_sticky` int(11) NOT NULL,
  `bg_type` int(11) NOT NULL,
  `bg_default` int(11) NOT NULL,
  `bg_modules` varchar(10000) NOT NULL,
  `bg_modules_global` varchar(10000) NOT NULL,
  `bg_background_collapse_bar` int(11) NOT NULL,
  `bg_background_collapse_main` int(11) NOT NULL,
  `bg_background_collapse_sec` int(11) NOT NULL,
  PRIMARY KEY (`bg_id`),
  KEY `bg_background` (`bg_background`),
  KEY `bg_type` (`bg_type`),
  KEY `bg_background_2` (`bg_background`,`bg_background_sec`,`bg_background_sticky`,`bg_default`),
  FULLTEXT KEY `bg_modules` (`bg_modules`),
  FULLTEXT KEY `bg_modules_global` (`bg_modules_global`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_backgrounds_slides`;
CREATE TABLE `site_core_backgrounds_slides` (
  `slide_id` int(11) NOT NULL AUTO_INCREMENT,
  `slide_order` int(11) NOT NULL,
  `slide_parent` int(11) NOT NULL,
  `slide_img` int(1) NOT NULL,
  PRIMARY KEY (`slide_id`),
  KEY `slide_order` (`slide_order`),
  KEY `slide_parent` (`slide_parent`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `site_core_backgrounds` (`image_id`, `image_name`, `image_cat`, `image_type`, `image_status`, `image_device`, `image_img`, `image_img_position_x`, `image_img_position_y`, `image_img_size`, `image_img_repeat`, `image_img_fixed`, `image_color`, `image_color_alpha`, `image_default`, `image_modules`, `image_modules_global`, `image_video`, `image_video_file`, `image_inverted`, `image_overlay`, `image_kb_scale`, `image_kb_scale_to`, `image_kb_duration`, `image_kb_fade`, `image_kb_transition`, `image_kb_posx`, `image_kb_posy`, `image_youtube`, `image_volume`, `image_start`, `image_particles`, `image_particles_file`, `image_particles_file_file`, `image_slider_transition`, `image_slider_duration`, `image_slider_transition_duration`) VALUES
(1,	'Placeholder - Slider',	'',	5,	1,	'1,2,3',	0,	'center',	'top',	'cover',	'no-repeat',	0,	'#ffffff',	1,	0,	'',	'',	0,	'',	1,	'1',	1.5,	1,	10,	0,	'linear',	'center',	'center',	'',	0,	0,	0,	0,	'',	'fade',	'2500',	800);

INSERT INTO `site_core_backgrounds_slides` (`slide_id`, `slide_order`, `slide_parent`, `slide_img`) VALUES
(1,	1,	1,	1),
(2,	2,	1,	1),
(3,	3,	1,	1);
